﻿using PX.Data;
using PX.Objects.PM;
using PX.Objects.SO;
using SD24R2.DAC.Ext;
using System.Linq;
using static PX.Objects.PM.ProjectAttributeGroupMaint;

namespace SD24R2.BLC.Ext
{
    public class ProjectAttributeGroupMaintExt : PXGraphExtension<ProjectAttributeGroupMaint>
    {
        [PXOverride]
        public string getEntityName(string classid)
        {
            switch (classid)
            {
                case Common.Constants.CustomerLocation:
                    return typeof(LocationExt).FullName;
                default:
                    return getEntityNameStatic(classid);
            }
        }

        public override void Initialize()
        {
            AddCustomerLocationClass();
            base.Initialize();
            var gi = PXGenericInqGrph.CreateInstance("SO3010PL");
            var res = gi.Results.Select();
            GenericResult result = res.FirstOrDefault();
            result.Values.TryGetValue(nameof(SOOrder), out var soOrder0);
            SOOrder soOrder = soOrder0 as SOOrder;
            decimal? orderQty = soOrder.OrderQty;
        }

        public virtual void AddCustomerLocationClass()
        {
            PXStringListAttribute.AppendList<GroupTypeFilter.classID>(Base.Filter.Cache, null,
                new string[] { Common.Constants.CustomerLocation },
                new string[] { Common.Constants.Messages.CustomerLocation });
        }
    }
}
