﻿using PX.Data;
using PX.Data.BQL.Fluent;
using PX.Objects.CR;
using PX.Objects.CS;
using System;

namespace SD24R2.DAC
{
    [PXCacheName("Master")]
    public class Master : PXBqlTable, IBqlTable
    {
        #region OrderType
        public abstract class orderType : PX.Data.BQL.BqlString.Field<orderType> { }

        [PXDBString(2, IsKey = true, IsFixed = true, InputMask = ">aa")]
        [PXDefault("AA")]
        [PXSelector(typeof(Search<MasterType.orderType>))]
        [PXUIField(DisplayName = "Order Type", Visibility = PXUIVisibility.SelectorVisible)]
        [PX.Data.EP.PXFieldDescription]
        public virtual string OrderType { get; set; }
        #endregion

        #region OrderNbr
        public abstract class orderNbr : PX.Data.BQL.BqlString.Field<orderNbr> { }

        [PXDBString(15, IsKey = true, IsUnicode = true, InputMask = ">CCCCCCCCCCCCCCC")]
        [PXDefault()]
        [PXUIField(DisplayName = "Order Nbr.", Visibility = PXUIVisibility.SelectorVisible)]
        [PXSelector(typeof(SearchFor<Master.orderNbr>
            .In<SelectFrom<Master>
                .Where<Master.orderType.IsEqual<Master.orderType.FromCurrent>>
            .OrderBy<Master.orderNbr.Desc>>))]
        [AutoNumber(typeof(Search<MasterType.orderNumberingID, 
                Where<MasterType.orderType, Equal<Current<Master.orderType>>>>), 
            typeof(AccessInfo.businessDate))]
        [PX.Data.EP.PXFieldDescription]
        public virtual string OrderNbr { get; set; }
        #endregion

        #region OrderDesc
        public abstract class orderDesc : PX.Data.BQL.BqlString.Field<orderDesc> { }

        [PXDBString(256, IsUnicode = true)]
        [PXUIField(DisplayName = "Description", Visibility = PXUIVisibility.SelectorVisible)]
        public virtual string OrderDesc { get; set; }
        #endregion

        #region Attributes

        [CRAttributesField(typeof(Master.orderType))]
        public virtual string[] Attributes { get; set; }
        public abstract class attributes : BqlAttributes.Field<attributes> { }

        public virtual string ClassID => OrderType;
        #endregion

        #region Audit Fields
        #region NoteID
        public abstract class noteID : PX.Data.BQL.BqlGuid.Field<noteID> { }

        [PXNote]
        public virtual Guid? NoteID
        {
            get;
            set;
        }
        #endregion

        #region CreatedByID
        public abstract class createdByID : PX.Data.BQL.BqlGuid.Field<createdByID> { }

        [PXDBCreatedByID]
        public virtual Guid? CreatedByID
        {
            get;
            set;
        }
        #endregion

        #region CreatedByScreenID
        public abstract class createdByScreenID : PX.Data.BQL.BqlString.Field<createdByScreenID> { }

        [PXDBCreatedByScreenID]
        public virtual string CreatedByScreenID
        {
            get;
            set;
        }
        #endregion

        #region CreatedDateTime
        public abstract class createdDateTime : PX.Data.BQL.BqlDateTime.Field<createdDateTime> { }

        [PXDBCreatedDateTime]
        public virtual DateTime? CreatedDateTime
        {
            get;
            set;
        }
        #endregion

        #region LastModifiedByID
        public abstract class lastModifiedByID : PX.Data.BQL.BqlGuid.Field<lastModifiedByID> { }

        [PXDBLastModifiedByID]
        public virtual Guid? LastModifiedByID
        {
            get;
            set;
        }
        #endregion

        #region LastModifiedByScreenID
        public abstract class lastModifiedByScreenID : PX.Data.BQL.BqlString.Field<lastModifiedByScreenID> { }

        [PXDBLastModifiedByScreenID]
        public virtual string LastModifiedByScreenID
        {
            get;
            set;
        }
        #endregion

        #region LastModifiedDateTime
        public abstract class lastModifiedDateTime : PX.Data.BQL.BqlDateTime.Field<lastModifiedDateTime> { }

        [PXDBLastModifiedDateTime]
        public virtual DateTime? LastModifiedDateTime
        {
            get;
            set;
        }
        #endregion

        #region tstamp
        public abstract class Tstamp : PX.Data.BQL.BqlByteArray.Field<Tstamp> { }

        [PXDBTimestamp]
        public virtual byte[] tstamp
        {
            get;
            set;
        }
        #endregion
        #endregion
    }
}
